	function h = IDEAL_IMPULSE_LP_Z(WcT, N)

	% 	Computes impulse response of an ideal digital lowpass filter
	% 	with cutoff angle WcT. The length of the impulse response is N+1

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	 
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	%	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	M = N+1;
	for n = 1:M	% Impulse response for an ideal lowpass filter
		if n ~= M/2
			h(n) = (WcT/pi)*sin(WcT*(n-M/2))/(WcT*(n-M/2));
		else
			h(n) = WcT/pi;
		end
	end
